/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.fake.internal;

import com.comphenix.protocol.events.PacketContainer;
import com.github.monun.survival.tap.fake.FakeEntity;
import com.github.monun.survival.tap.fake.FakeSupportKt;
import com.github.monun.survival.tap.fake.internal.FakeEntityImplKt;
import com.github.monun.survival.tap.fake.internal.FakeEntityServerImpl;
import com.github.monun.survival.tap.fake.internal.FakeTracker;
import com.github.monun.survival.tap.fake.internal.FakeTrackerKt;
import com.github.monun.survival.tap.protocol.PacketSupport;
import com.github.monun.survival.tap.protocol.ProtocolSupportKt;
import com.github.monun.survival.tap.ref.UpstreamReference;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002cdB\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0001H\u0016J\u0010\u0010?\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0001H\u0002J\u0006\u0010@\u001a\u00020AJ\r\u0010B\u001a\u00020AH\u0000\u00a2\u0006\u0002\bCJ\u0010\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020/H\u0002J\r\u0010F\u001a\u00020AH\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u00020A2\u0006\u0010I\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\bJJ\b\u0010K\u001a\u00020\u000fH\u0016J\r\u0010L\u001a\u00020AH\u0000\u00a2\u0006\u0002\bMJ\u0010\u0010N\u001a\u00020A2\u0006\u0010I\u001a\u00020\u0018H\u0016J\u0010\u0010O\u001a\u00020A2\u0006\u0010I\u001a\u00020\u0018H\u0016J\u0010\u0010P\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u0007H\u0016J\u0015\u0010R\u001a\u00020A2\u0006\u0010E\u001a\u00020/H\u0000\u00a2\u0006\u0002\bSJ\b\u0010T\u001a\u00020AH\u0016J\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0001H\u0016J\u0015\u0010V\u001a\u00020A2\u0006\u0010E\u001a\u00020/H\u0000\u00a2\u0006\u0002\bWJ\u0010\u0010X\u001a\u00020A2\u0006\u0010I\u001a\u00020\u0018H\u0002J\r\u0010Y\u001a\u00020AH\u0000\u00a2\u0006\u0002\bZJ!\u00101\u001a\u00020A2\u0017\u0010[\u001a\u0013\u0012\u0004\u0012\u00020]\u0012\u0004\u0012\u00020A0\\\u00a2\u0006\u0002\b^H\u0016J\b\u00102\u001a\u00020_H\u0002J+\u0010`\u001a\u00020A\"\b\b\u0000\u0010a*\u00020\u00052\u0017\u0010[\u001a\u0013\u0012\u0004\u0012\u0002Ha\u0012\u0004\u0012\u00020A0\\\u00a2\u0006\u0002\b^H\u0016J\b\u0010b\u001a\u00020AH\u0002J\b\u00106\u001a\u00020AH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R2\u0010\u0016\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R&\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020/0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00108\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0011R\"\u0010:\u001a\u0004\u0018\u00010\u00002\b\u00107\u001a\u0004\u0018\u00010\u0000@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006e"}, d2={"Lcom/github/monun/survival/tap/fake/internal/FakeEntityImpl;", "Lcom/github/monun/survival/tap/fake/FakeEntity;", "server", "Lcom/github/monun/survival/tap/fake/internal/FakeEntityServerImpl;", "bukkitEntity", "Lorg/bukkit/entity/Entity;", "location", "Lorg/bukkit/Location;", "(Lcom/github/monun/tap/fake/internal/FakeEntityServerImpl;Lorg/bukkit/entity/Entity;Lorg/bukkit/Location;)V", "_passengers", "Ljava/util/HashSet;", "getBukkitEntity", "()Lorg/bukkit/entity/Entity;", "currentLocation", "dead", "", "getDead", "()Z", "deltaLocation", "enqueued", "equipmentData", "Lcom/github/monun/survival/tap/fake/internal/FakeEntityImpl$ItemData;", "exclusion", "", "Lorg/bukkit/entity/Player;", "kotlin.jvm.PlatformType", "", "isDone", "value", "isVisible", "setVisible", "(Z)V", "getLocation", "()Lorg/bukkit/Location;", "moveTicks", "", "passengers", "", "getPassengers", "()Ljava/util/List;", "previousLocation", "getServer", "()Lcom/github/monun/tap/fake/internal/FakeEntityServerImpl;", "serverRef", "Lcom/github/monun/survival/tap/ref/UpstreamReference;", "trackerComputeQueue", "Ljava/util/ArrayDeque;", "Lcom/github/monun/survival/tap/fake/internal/FakeTracker;", "trackers", "updateEquipment", "updateLocation", "updateMeta", "updatePassengers", "updateTeleport", "updateTrackers", "<set-?>", "valid", "getValid", "vehicle", "getVehicle", "()Lcom/github/monun/tap/fake/internal/FakeEntityImpl;", "addPassenger", "passenger", "check", "checkState", "", "clearTrackers", "clearTrackers$api", "computeTracker", "tracker", "despawn", "despawn$api", "despawnTo", "player", "despawnTo$api", "eject", "enqueue", "enqueue$api", "excludeTracker", "includeTracker", "moveTo", "target", "offerComputeQueue", "offerComputeQueue$api", "remove", "removePassenger", "removeTracker", "removeTracker$api", "spawnTo", "update", "update$api", "applier", "Lkotlin/Function1;", "Lorg/bukkit/inventory/EntityEquipment;", "Lkotlin/ExtensionFunctionType;", "Lcom/github/monun/survival/tap/fake/internal/FakeEntityImpl$MoveResult;", "updateMetadata", "T", "updatePassengerLocation", "ItemData", "MoveResult", "api"})
public final class FakeEntityImpl
implements FakeEntity {
    private final UpstreamReference<FakeEntityServerImpl> serverRef;
    private final Location deltaLocation;
    private final Location previousLocation;
    private final Location currentLocation;
    private final HashSet<FakeTracker> trackers;
    private final ArrayDeque<FakeTracker> trackerComputeQueue;
    @Nullable
    private FakeEntityImpl vehicle;
    private final HashSet<FakeEntityImpl> _passengers;
    private boolean updateTrackers;
    private boolean updateLocation;
    private boolean updateTeleport;
    private boolean updatePassengers;
    private boolean updateMeta;
    private boolean updateEquipment;
    private boolean enqueued;
    private boolean valid;
    private ItemData equipmentData;
    private int moveTicks;
    private boolean isVisible;
    private final Set<Player> exclusion;
    @NotNull
    private final Entity bukkitEntity;

    @Override
    @NotNull
    public FakeEntityServerImpl getServer() {
        return this.serverRef.get();
    }

    @Override
    @NotNull
    public Location getLocation() {
        Location location = this.currentLocation.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"currentLocation.clone()");
        return location;
    }

    @Override
    @Nullable
    public FakeEntityImpl getVehicle() {
        return this.vehicle;
    }

    @Override
    @NotNull
    public List<FakeEntity> getPassengers() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this._passengers);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ImmutableList.copyOf(_passengers)");
        return (List)immutableList;
    }

    @Override
    public boolean getValid() {
        return this.valid;
    }

    @Override
    public boolean getDead() {
        return !this.getValid();
    }

    public final boolean isDone() {
        return !this.updateLocation;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible && this.getValid();
    }

    @Override
    public void setVisible(boolean value) {
        this.checkState();
        if (this.isVisible != value) {
            this.isVisible = value;
            this.updateTrackers = true;
            this.enqueue$api();
        }
    }

    private final FakeEntityImpl check(FakeEntity passenger) {
        FakeEntity fakeEntity = passenger;
        if (fakeEntity == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.github.monun.tap.fake.internal.FakeEntityImpl");
        }
        FakeEntityImpl impl = (FakeEntityImpl)fakeEntity;
        ((FakeEntityImpl)passenger).checkState();
        boolean bl = impl.getServer() == this.getServer();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return impl;
    }

    @Override
    public boolean addPassenger(@NotNull FakeEntity passenger) {
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        this.checkState();
        FakeEntityImpl impl = this.check(passenger);
        Object object = passenger;
        boolean bl = false;
        boolean bl2 = false;
        FakeEntity it = object;
        boolean bl3 = false;
        for (FakeEntityImpl entity = this; entity != null; entity = entity.getVehicle()) {
            if (entity != it) continue;
            return false;
        }
        passenger.eject();
        impl.vehicle = this;
        object = this._passengers;
        bl = false;
        object.add(impl);
        this.updatePassengers = true;
        this.enqueue$api();
        impl.updateLocation = true;
        impl.enqueue$api();
        return true;
    }

    @Override
    public boolean removePassenger(@NotNull FakeEntity passenger) {
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        FakeEntityImpl impl = this.check(passenger);
        if (impl.getVehicle() != this) {
            return false;
        }
        impl.vehicle = null;
        Collection collection = this._passengers;
        boolean bl = false;
        collection.remove(impl);
        this.updatePassengers = true;
        this.enqueue$api();
        impl.updateLocation = true;
        impl.updateTeleport = true;
        impl.enqueue$api();
        return true;
    }

    @Override
    public boolean eject() {
        FakeEntityImpl fakeEntityImpl = this.getVehicle();
        return fakeEntityImpl != null ? fakeEntityImpl.removePassenger(this) : false;
    }

    @Override
    public void moveTo(@NotNull Location target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.getDead() || this.getVehicle() != null || Intrinsics.areEqual((Object)this.previousLocation, (Object)target)) {
            return;
        }
        FakeEntityImplKt.access$set(this.currentLocation, target);
        this.updateLocation = true;
        this.updateTrackers = true;
        this.moveTicks = 20;
        this.enqueue$api();
        this.updatePassengerLocation();
    }

    private final void updatePassengerLocation() {
        for (FakeEntityImpl passenger : this._passengers) {
            passenger.updateLocation = true;
            passenger.updateTrackers = true;
            passenger.enqueue$api();
            passenger.updatePassengerLocation();
        }
    }

    public final void enqueue$api() {
        if (!this.enqueued) {
            this.enqueued = true;
            this.getServer().enqueue$api(this);
        }
    }

    public final void offerComputeQueue$api(@NotNull FakeTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (this.trackers.contains(tracker)) {
            this.computeTracker(tracker);
        }
        if (this.updateTrackers) {
            return;
        }
        this.trackerComputeQueue.offer(tracker);
        this.enqueue$api();
    }

    public final void update$api() {
        block13: {
            block14: {
                this.enqueued = false;
                if (!this.getValid()) {
                    HashSet<FakeEntityImpl> hashSet = this._passengers;
                    boolean bl = false;
                    boolean bl2 = false;
                    HashSet<FakeEntityImpl> $this$apply = hashSet;
                    boolean bl3 = false;
                    for (FakeEntityImpl passenger : $this$apply) {
                        passenger.vehicle = null;
                    }
                    $this$apply.clear();
                    this.despawn$api();
                    for (FakeTracker tracker : this.trackers) {
                        tracker.removeEntity$api(this);
                    }
                    this.clearTrackers$api();
                    return;
                }
                if (this.updateMeta) {
                    this.updateMeta = false;
                    FakeTrackerKt.sendServerPacketAll((Iterable<FakeTracker>)this.trackers, ProtocolSupportKt.getPacket().entityMetadata(this.getBukkitEntity()));
                }
                if (this.updateEquipment) {
                    this.updateEquipment = false;
                    ItemData itemData = this.equipmentData;
                    if (itemData == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"equipmentData");
                    }
                    itemData.update();
                }
                if (this.updatePassengers) {
                    this.updatePassengers = false;
                    FakeTrackerKt.sendServerPacketAll((Iterable<FakeTracker>)this.trackers, ProtocolSupportKt.getPacket().mount(this.getBukkitEntity().getEntityId(), FakeEntityImplKt.access$toIntArray(this._passengers)));
                }
                if (!this.updateLocation) break block13;
                MoveResult result = this.updateLocation();
                if (result == MoveResult.TELEPORT || result == MoveResult.VEHICLE) break block14;
                FakeEntityImpl fakeEntityImpl = this;
                fakeEntityImpl.moveTicks += -1;
                if (fakeEntityImpl.moveTicks > 0) break block13;
            }
            this.updateLocation = false;
            this.moveTicks = 0;
        }
        if (this.updateTrackers) {
            this.updateTrackers = false;
            this.updateTrackers();
            this.trackerComputeQueue.clear();
        }
        if (!this.isVisible()) {
            this.trackerComputeQueue.clear();
        }
        ArrayDeque<FakeTracker> arrayDeque = this.trackerComputeQueue;
        boolean bl = false;
        boolean bl4 = false;
        ArrayDeque<FakeTracker> queue = arrayDeque;
        boolean bl5 = false;
        while (true) {
            Collection collection = queue;
            boolean bl6 = false;
            if (!(!collection.isEmpty())) break;
            FakeTracker fakeTracker = queue.remove();
            Intrinsics.checkNotNullExpressionValue((Object)fakeTracker, (String)"queue.remove()");
            this.computeTracker(fakeTracker);
        }
    }

    private final MoveResult updateLocation() {
        MoveResult moveResult;
        Entity bukkitEntity = this.getBukkitEntity();
        FakeEntityImpl fakeEntityImpl = this.getVehicle();
        if (fakeEntityImpl != null) {
            FakeEntityImpl fakeEntityImpl2 = fakeEntityImpl;
            boolean bl = false;
            boolean bl2 = false;
            FakeEntityImpl vehicle = fakeEntityImpl2;
            boolean bl3 = false;
            double yOffset = FakeSupportKt.getMountedYOffset(vehicle.getBukkitEntity());
            FakeEntityImplKt.access$mount(this.deltaLocation, vehicle.deltaLocation, yOffset);
            FakeEntityImplKt.access$mount(this.previousLocation, vehicle.previousLocation, yOffset);
            FakeEntityImplKt.access$mount(this.currentLocation, vehicle.currentLocation, yOffset);
            FakeSupportKt.setLocation(bukkitEntity, this.deltaLocation);
            for (FakeTracker tracker : this.trackers) {
                if (vehicle.trackers.contains(tracker)) continue;
                ProtocolSupportKt.sendServerPacket(tracker.getPlayer(), PacketSupport.DefaultImpls.entityTeleport$default(ProtocolSupportKt.getPacket(), bukkitEntity, this.deltaLocation, false, 4, null));
            }
            return MoveResult.VEHICLE;
        }
        Location from = this.deltaLocation;
        Location to = this.currentLocation;
        long deltaX = FakeEntityImplKt.delta(from.getX(), to.getX());
        long deltaY = FakeEntityImplKt.delta(from.getY(), to.getY());
        long deltaZ = FakeEntityImplKt.delta(from.getZ(), to.getZ());
        Vector moveDelta = new Vector((double)deltaX / 4096.0, (double)deltaY / 4096.0, (double)deltaZ / 4096.0);
        if (this.updateTeleport || from.getWorld() != to.getWorld() || deltaX < -32768L || deltaX > 32767L || deltaY < -32768L || deltaY > 32767L || deltaZ < -32768L || deltaZ > 32767L) {
            this.updateTeleport = false;
            FakeEntityImplKt.access$set(this.deltaLocation, to);
            FakeSupportKt.setLocation(bukkitEntity, to);
            FakeTrackerKt.sendServerPacketAll((Iterable<FakeTracker>)this.trackers, PacketSupport.DefaultImpls.entityTeleport$default(ProtocolSupportKt.getPacket(), bukkitEntity, to, false, 4, null));
            moveResult = MoveResult.TELEPORT;
        } else {
            float yaw = to.getYaw();
            float pitch = to.getPitch();
            PacketContainer packet = ProtocolSupportKt.getPacket().relEntityMoveLook(bukkitEntity.getEntityId(), (short)deltaX, (short)deltaY, (short)deltaZ, yaw, pitch, false);
            Location location = this.deltaLocation;
            boolean bl = false;
            boolean bl4 = false;
            Location $this$apply = location;
            boolean bl5 = false;
            $this$apply.add(moveDelta);
            $this$apply.setYaw(to.getYaw());
            $this$apply.setPitch(to.getPitch());
            FakeSupportKt.setLocation(bukkitEntity, this.deltaLocation);
            FakeTrackerKt.sendServerPacketAll((Iterable<FakeTracker>)this.trackers, packet);
            moveResult = MoveResult.REL_MOVE;
        }
        MoveResult result = moveResult;
        FakeEntityImplKt.access$set(this.previousLocation, this.currentLocation);
        return result;
    }

    private final void updateTrackers() {
        for (FakeTracker tracker : this.getServer().getTrackers$api()) {
            this.computeTracker(tracker);
        }
    }

    private final void computeTracker(FakeTracker tracker) {
        if (!tracker.getValid$api()) {
            return;
        }
        if (this.isVisible() && !this.exclusion.contains(tracker.getPlayer())) {
            double distanceSquared;
            double spawnDistanceSquared = 57600.0;
            double despawnDistanceSquared = 65536.0;
            Location entityLocation = this.deltaLocation;
            Location trackerLocation = tracker.getLocation$api();
            if (entityLocation.getWorld() == trackerLocation.getWorld() && (distanceSquared = entityLocation.distanceSquared(trackerLocation)) < despawnDistanceSquared) {
                if (distanceSquared < spawnDistanceSquared && this.trackers.add(tracker)) {
                    tracker.addEntity$api(this);
                    this.spawnTo(tracker.getPlayer());
                }
                return;
            }
        }
        if (this.trackers.remove(tracker)) {
            tracker.removeEntity$api(this);
            this.despawnTo$api(tracker.getPlayer());
        }
    }

    public final void removeTracker$api(@NotNull FakeTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Collection collection = this.trackers;
        boolean bl = false;
        collection.remove(tracker);
    }

    private final void spawnTo(Player player2) {
        block3: {
            Entity bukkitEntity = this.getBukkitEntity();
            ProtocolSupportKt.sendServerPacket(player2, FakeSupportKt.createSpawnPacket(bukkitEntity));
            ProtocolSupportKt.sendServerPacket(player2, ProtocolSupportKt.getPacket().entityMetadata(bukkitEntity));
            if (bukkitEntity instanceof ArmorStand) {
                Iterable $this$forEach$iv = ProtocolSupportKt.getPacket().entityEquipment((LivingEntity)bukkitEntity);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PacketContainer packet = (PacketContainer)element$iv;
                    boolean bl = false;
                    ProtocolSupportKt.sendServerPacket(player2, packet);
                }
            }
            Object object = this._passengers;
            boolean bl = false;
            boolean bl2 = false;
            HashSet<FakeEntityImpl> passengers = object;
            boolean bl3 = false;
            Collection collection = passengers;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                ProtocolSupportKt.sendServerPacket(player2, ProtocolSupportKt.getPacket().mount(bukkitEntity.getEntityId(), FakeEntityImplKt.access$toIntArray(passengers)));
            }
            FakeEntityImpl fakeEntityImpl = this.getVehicle();
            if (fakeEntityImpl == null) break block3;
            object = fakeEntityImpl;
            bl = false;
            bl2 = false;
            Object vehicle = object;
            boolean bl5 = false;
            ProtocolSupportKt.sendServerPacket(player2, ProtocolSupportKt.getPacket().mount(((FakeEntityImpl)vehicle).getBukkitEntity().getEntityId(), FakeEntityImplKt.access$toIntArray(((FakeEntityImpl)vehicle)._passengers)));
        }
    }

    public final void despawn$api() {
        FakeTrackerKt.sendServerPacketAll((Iterable<FakeTracker>)this.trackers, ProtocolSupportKt.getPacket().entityDestroy(new int[]{this.getBukkitEntity().getEntityId()}));
    }

    public final void clearTrackers$api() {
        this.trackers.clear();
    }

    public final void despawnTo$api(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
        ProtocolSupportKt.sendServerPacket(player2, ProtocolSupportKt.getPacket().entityDestroy(new int[]{this.getBukkitEntity().getEntityId()}));
    }

    @Override
    public <T extends Entity> void updateMetadata(@NotNull Function1<? super T, Unit> applier) {
        Intrinsics.checkNotNullParameter(applier, (String)"applier");
        if (this.getDead()) {
            return;
        }
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            throw new NullPointerException("null cannot be cast to non-null type T");
        }
        Entity entity2 = entity;
        applier.invoke((Object)entity2);
        this.updateMeta = true;
        this.enqueue$api();
    }

    @Override
    public void updateEquipment(@NotNull Function1<? super EntityEquipment, Unit> applier) {
        block2: {
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            if (this.getDead()) {
                return;
            }
            Entity entity = this.getBukkitEntity();
            if (entity == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            }
            LivingEntity living = (LivingEntity)entity;
            EntityEquipment entityEquipment = living.getEquipment();
            if (entityEquipment == null) break block2;
            EntityEquipment entityEquipment2 = entityEquipment;
            boolean bl = false;
            boolean bl2 = false;
            EntityEquipment equipment = entityEquipment2;
            boolean bl3 = false;
            EntityEquipment entityEquipment3 = equipment;
            Intrinsics.checkNotNullExpressionValue((Object)entityEquipment3, (String)"equipment");
            applier.invoke((Object)entityEquipment3);
            this.updateEquipment = true;
            this.enqueue$api();
        }
    }

    @Override
    public void excludeTracker(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
        if (this.exclusion.add(player2)) {
            this.updateTrackers = true;
            this.enqueue$api();
        }
    }

    @Override
    public void includeTracker(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
        if (this.exclusion.remove(player2)) {
            this.updateTrackers = true;
            this.enqueue$api();
        }
    }

    public final void checkState() {
        boolean bl = this.getValid();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Invalid ").append(this.getClass().getSimpleName()).append('@');
            int n = System.identityHashCode(this);
            int n2 = 16;
            boolean bl5 = false;
            String string2 = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string3 = stringBuilder.append(string2).toString();
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    public void remove() {
        if (this.getValid()) {
            this.valid = false;
            this.enqueue$api();
        }
    }

    @Override
    @NotNull
    public Entity getBukkitEntity() {
        return this.bukkitEntity;
    }

    public FakeEntityImpl(@NotNull FakeEntityServerImpl server, @NotNull Entity bukkitEntity, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)bukkitEntity, (String)"bukkitEntity");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.bukkitEntity = bukkitEntity;
        this.serverRef = new UpstreamReference<FakeEntityServerImpl>(server);
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone()");
        this.deltaLocation = location2;
        Location location3 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"location.clone()");
        this.previousLocation = location3;
        Location location4 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"location.clone()");
        this.currentLocation = location4;
        this.trackers = new HashSet();
        this.trackerComputeQueue = new ArrayDeque();
        this._passengers = new HashSet();
        this.updateTrackers = true;
        this.valid = true;
        this.isVisible = true;
        this.exclusion = Collections.newSetFromMap(new WeakHashMap());
        if (this.getBukkitEntity() instanceof ArmorStand) {
            this.equipmentData = new ItemData();
        }
    }

    @Override
    public void move(double x, double y, double z) {
        FakeEntity.DefaultImpls.move(this, x, y, z);
    }

    @Override
    public void moveAndRotation(double x, double y, double z, float yaw, float pitch) {
        FakeEntity.DefaultImpls.moveAndRotation(this, x, y, z, yaw, pitch);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/monun/survival/tap/fake/internal/FakeEntityImpl$ItemData;", "", "(Lcom/github/monun/tap/fake/internal/FakeEntityImpl;)V", "itemsBySlot", "Ljava/util/EnumMap;", "Lorg/bukkit/inventory/EquipmentSlot;", "Lorg/bukkit/inventory/ItemStack;", "update", "", "api"})
    private final class ItemData {
        private final EnumMap<EquipmentSlot, ItemStack> itemsBySlot = new EnumMap(EquipmentSlot.class);

        public final void update() {
            Entity entity = FakeEntityImpl.this.getBukkitEntity();
            if (entity == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bukkit.entity.ArmorStand");
            }
            ArmorStand armorStand = (ArmorStand)entity;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack current;
                Intrinsics.checkNotNullExpressionValue((Object)armorStand.getItem(slot), (String)"armorStand.getItem(slot)");
                ItemStack old = this.itemsBySlot.put((EquipmentSlot)((Enum)slot), current);
                if ((old != null || current.getType() == Material.AIR) && current.isSimilar(old)) continue;
                FakeTrackerKt.sendServerPacketAll(FakeEntityImpl.this.trackers, ProtocolSupportKt.getPacket().entityEquipment(armorStand.getEntityId(), slot, current));
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/monun/survival/tap/fake/internal/FakeEntityImpl$MoveResult;", "", "(Ljava/lang/String;I)V", "TELEPORT", "REL_MOVE", "VEHICLE", "api"})
    private static final class MoveResult
    extends Enum<MoveResult> {
        public static final /* enum */ MoveResult TELEPORT;
        public static final /* enum */ MoveResult REL_MOVE;
        public static final /* enum */ MoveResult VEHICLE;
        private static final /* synthetic */ MoveResult[] $VALUES;

        static {
            MoveResult[] moveResultArray = new MoveResult[3];
            MoveResult[] moveResultArray2 = moveResultArray;
            moveResultArray[0] = TELEPORT = new MoveResult();
            moveResultArray[1] = REL_MOVE = new MoveResult();
            moveResultArray[2] = VEHICLE = new MoveResult();
            $VALUES = moveResultArray;
        }

        public static MoveResult[] values() {
            return (MoveResult[])$VALUES.clone();
        }

        public static MoveResult valueOf(String string2) {
            return Enum.valueOf(MoveResult.class, string2);
        }
    }
}

